% this script uses multirate_matlab6.m to generate
% all the results for the J Sci Comp paper

% (i) Snapshots at 4 times for each of the equations
% (ii) 4th order convergence plot
% (iii) Macrostep/microstep ratio along with error


% (i) snapshots/quadplot

MR = 1; CONSTANT_STEPS = 0; QUAD_PLOT = 1; PLOTTING = 0; 

EQN = 1; dt_initial = 0.01;  delta = 1e-4; TOL = 1e-6; figure(1);
[~,~,~,~,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);
EQN = 2; dt_initial = 0.0005;  delta = 1e-2; TOL = 1e-8; figure(2);
[~,~,~,~,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);
EQN = 3; dt_initial = 0.005; delta = 1e-5; TOL = 1e-5; figure(3);
[~,~,~,~,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);


% (ii) 4th order convergence
MR = 1; CONSTANT_STEPS = 1; QUAD_PLOT = 0;
TOL = 1e-6; delta = 1e-12;
for EQN = 1:3
    if EQN == 1
        dt_initial = [0.01 0.025 0.05 0.1 0.2];
    elseif EQN == 2
        dt_initial = [0.0050    0.0040    0.0025    0.0020    0.0010    0.0005];
    elseif EQN == 3
        dt_initial = [0.0020    0.0010    0.0008    0.0005    0.0004    0.0002];
    end
    
    for j=1:length(dt_initial)
        [dt_macro_av(j),~,err(j),~,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial(j),delta);
    end
    subplot(1,3,EQN);
    loglog(dt_macro_av,err,'ks','LineWidth',2);
    if EQN == 1
        title('Transport','FontName','Times','FontSize',12);
    elseif EQN == 2
        title('Reaction-Diffusion','FontName','Times','FontSize',12);
    elseif EQN == 3
        title('Advection-Diffusion','FontName','Times','FontSize',12);
    end
    xlabel('h','FontAngle','italic','FontName','Times','FontSize',12);
    ylabel('Infinity Norm Error','FontName','Times','FontSize',12);
end


% (iii) Single Rate vs Multirate
TOL = 1e-4; delta = 1e-12;
MR = 0; CONSTANT_STEPS = 0; QUAD_PLOT = 0;
EQN = 1; dt_initial = 0.01;
[~,~,err1,num_macro_steps1,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);
EQN = 2; dt_initial = 0.0005;
[~,~,err2,num_macro_steps2,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta); 
EQN = 3; dt_initial = 0.005;
[~,~,err3,num_macro_steps3,~] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);

MR = 1; CONSTANT_STEPS = 0; QUAD_PLOT = 0;
EQN = 1; dt_initial = 0.01;
[~,~,err4,num_macro_steps4,num_micro_steps4] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);
EQN = 2; dt_initial = 0.0005;
[~,~,err5,num_macro_steps5,num_micro_steps5] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta); 
EQN = 3; dt_initial = 0.005;
[~,~,err6,num_macro_steps6,num_micro_steps6] = multirate_matlab6(TOL,PLOTTING,MR,CONSTANT_STEPS,QUAD_PLOT,EQN,dt_initial,delta);
% 
sprintf('Equation | # macrosteps (error) | # macrosteps/#microsteps (error)')
sprintf('Transport: %d (%.2e) %d/%d (%.2e)',num_macro_steps1,err1,num_macro_steps4,num_micro_steps4,err4)
sprintf('Reaction-Diffusion: %d (%.2e) %d/%d (%.2e)',num_macro_steps2,err2,num_macro_steps5,num_micro_steps5,err5)
sprintf('Advection-Diffusion: %d (%.2e) %d/%d (%.2e)',num_macro_steps3,err3,num_macro_steps6,num_micro_steps6,err6)

