function y = fisher_exact(x,t,epsilon,gamma,NumCpts)
% exact ODE solution to u_t = epsilon*u_xx + gamma*u^2*(1-u)

lambda = 0.5*sqrt(2*gamma/epsilon);
u0 = 1./(1+exp(lambda*(x-1)));
options = odeset('RelTol',1e-13,'AbsTol',1e-15);
[~,u_exact]=ode15s(@(t,u) rhs(u,x,gamma,epsilon,NumCpts),[0 t],u0,options);

y = u_exact(end,:)';
% plot(x,y)
end


function out = rhs(u,x,gamma,epsilon,NumCpts)
h = x(2)-x(1);
out = zeros(NumCpts,1);
out(1) = 0; out(NumCpts) = 0;
out(2:NumCpts-1) = epsilon*(u(3:NumCpts)-2*u(2:NumCpts-1)+u(1:NumCpts-2))/h^2 + gamma*u(2:NumCpts-1).^2.*(1-u(2:NumCpts-1));
end