function y_exact = advection_exact(t,N,a,L,x,h,y0)
% function y_exact = advection_exact(t)
% solves the method of lines discretization of u_t + a u_x = 0
% exactly using eigenvalues and eigenvectors


% N = 201;
% a = 2;
% L = 50;

% x = linspace(-L/2,L/2,N);
% h = 1; %x(2)-x(1);
% y0 = exp(-x.^2)';
% y0 = zeros(length(x),1); y0(round(N/2)) = 1;

% upwind
M = -(a/h)*( diag(ones(1,N),0) + diag(-ones(1,N-1),-1) );
M(1,end) = -1;

% centered differences
% M = -(a/2/h)*( diag(ones(1,N-1),1) - diag(ones(1,N-1),-1) );


[V,D]=eig(M);
c = inv(V)*y0;

y_exact = zeros(N,1);
for i=1:N
    y_exact = y_exact + c(i)*V(:,i)*exp(D(i,i)*t);
end


% plot(x,y_exact);