function M = GenerateM(dx,a,c,d,NumCpts)

% outputs the matrix M which is the fourth order accurate
% finite difference approximation to the advection-diffusion operator
% -a*d/dx + d*d2/dx2 - c
% for use with "parabolic_exact.m" and "multirate_matlab2.m"

vm2 = [0 0 -1/12*ones(1,NumCpts-4)];
vm1 = [0 0 4/3*ones(1,NumCpts-4) 0];
v0 = [0 0 -5/2*ones(1,NumCpts-4) 0 0];
v1 = [0 4/3*ones(1,NumCpts-4) 0 0];
v2 = [-1/12*ones(1,NumCpts-4) 0 0];

wm2 = [0 0 -1/12*ones(1,NumCpts-4)];
wm1 = [0 0 2/3*ones(1,NumCpts-4) 0];
w1 = [0 -2/3*ones(1,NumCpts-4) 0 0];
w2 = [1/12*ones(1,NumCpts-4) 0 0];

M = d/dx^2 * ( diag(vm2,2) + diag(vm1,1) + diag(v0,0) + diag(v1,-1) + diag(v2,-2) ) + ...
    -a/dx * ( diag(wm2,2) + diag(wm1,1) + diag(w1,-1) + diag(w2,-2) ) + ...
    -c*diag([0 0 ones(1,NumCpts-4) 0 0]);