function y = parabolic_exact(t,L,a,c,d,NumCpts)

% solves the discretization of u_t + au_x = du_xx - cu + g(x,t)
% with g(x,t) = 1000*cos(pi*x/2)^100 * sin(pi*t)
% to high accuracy using MATLAB's ode15

x = linspace(-L,L,NumCpts);
dx = x(2)-x(1);

M = GenerateM(dx,a,c,d,NumCpts);

u0 = zeros(1,NumCpts);
options = odeset('RelTol',1e-13,'AbsTol',1e-15);
[~,u_exact]=ode15s(@(t,u) dudt(t,u,M,x),[0 t],u0,options);

% plot(x,u_exact(end,:),'k-');
y = u_exact(end,:)';
end

function out = dudt(t,u,M,x)
    out = M*u + g(x,t); % g defined in separate file
end

